<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="de"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8" lang="de"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9" lang="de"> <![endif]-->
<!--[if gt IE 8]><!-->

<html class="no-js" lang="de">
<!--<![endif]-->

<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">

<title>MitarbeiterInnen Unternehmen — mindsetters</title>

<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="apple-touch-icon" sizes="180x180" href="assets/favicons/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="assets/favicons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="assets/favicons/favicon-16x16.png">
<link rel="manifest" href="assets/favicons/site.webmanifest">
<link rel="mask-icon" href="assets/favicons/safari-pinned-tab.svg" color="#242858">
<link rel="shortcut icon" href="assets/favicons/favicon.ico">
<meta name="msapplication-TileColor" content="#242858">
<meta name="msapplication-config" content="assets/favicons/browserconfig.xml">
<meta name="theme-color" content="#242858">

<link rel="stylesheet" href="assets/css/styles.css?<?php echo time(); ?>">

<script src="assets/js/jquery.js?<?php echo time(); ?>"></script>
<script src="assets/js/jquery-migrate.js?<?php echo time(); ?>"></script>
<script src="assets/js/modernizr.js"></script>

</head>

<body>
	
<div class="subpage">
	<nav id="nav">
		<a href="/" class="mindsetters-icon"><img src="assets/svg/icon-blue.svg" alt="mindsetters"></a>
		<ul class="nav">
			<li><a href="company-training">Schulungen</a></li>
			<li class="active"><a href="company-users">MitarbeiterInnen</a></li>
			<li><a href="company-profile">Unternehmensdaten</a></li>
			<li><a href="company-account">Benutzerkonto</a></li>
		</ul>
		<a href="#" class="logout">Logout</a>
		<div id="hamburger">
			<div class="line lineA"></div>
			<div class="line lineB"></div>
		</div>
	</nav>
	
	<div id="content" role="main">
		<div class="limit">
			<div class="content-header has-button">
				<h1>Verwaltung MitarbeiterInnen</h1>
				<div class="content-header-button">
					<a href="#" class="button green-button">Mitarbeiter importieren</a>
				</div>
			</div>
			
			<div class="content-item content-users">
				<div class="content-row">
					<div class="content-col">
						<div class="content-table">
							<table>
								<thead>
									<tr>
										<th class="col1"><input class="content-checkbox" type="checkbox" name="select-all"></th>
										<th class="col2">Vorname</th>
										<th class="col3">Nachname</th>
										<th class="col4 last-col">E-Mail</th>
									</tr>
								</thead>
								<tbody>
									<tr>
										<td class="col1"><input class="content-checkbox" type="checkbox" name="select01"></td>
										<td class="col2">Peter</td>
										<td class="col3">Rohrmoser</td>
										<td class="col4 last-col">peter@hungry.at</td>
									</tr>
									<tr>
										<td class="col1"><input class="content-checkbox" type="checkbox" name="select02"></td>
										<td class="col2">Peter</td>
										<td class="col3">Rohrmoser</td>
										<td class="col4 last-col">peter@hungry.at</td>
									</tr>
									<tr>
										<td class="col1"><input class="content-checkbox" type="checkbox" name="select03"></td>
										<td class="col2">Peter</td>
										<td class="col3">Rohrmoser</td>
										<td class="col4 last-col">peter@hungry.at</td>
									</tr>
									<tr>
										<td class="col1"><input class="content-checkbox" type="checkbox" name="select04"></td>
										<td class="col2">Peter</td>
										<td class="col3">Rohrmoser</td>
										<td class="col4 last-col">peter@hungry.at</td>
									</tr>
									<tr>
										<td class="col1"><input class="content-checkbox" type="checkbox" name="select05"></td>
										<td class="col2">Peter</td>
										<td class="col3">Rohrmoser</td>
										<td class="col4 last-col">peter@hungry.at</td>
									</tr>
									<tr>
										<td class="col1"><input class="content-checkbox" type="checkbox" name="select06"></td>
										<td class="col2">Peter</td>
										<td class="col3">Rohrmoser</td>
										<td class="col4 last-col">peter@hungry.at</td>
									</tr>
									<tr>
										<td class="col1"><input class="content-checkbox" type="checkbox" name="select07"></td>
										<td class="col2">Peter</td>
										<td class="col3">Rohrmoser</td>
										<td class="col4 last-col">peter@hungry.at</td>
									</tr>
									<tr>
										<td class="col1"><input class="content-checkbox" type="checkbox" name="select08"></td>
										<td class="col2">Peter</td>
										<td class="col3">Rohrmoser</td>
										<td class="col4 last-col">peter@hungry.at</td>
									</tr>
									<tr>
										<td class="col1"><input class="content-checkbox" type="checkbox" name="select09"></td>
										<td class="col2">Peter</td>
										<td class="col3">Rohrmoser</td>
										<td class="col4 last-col">peter@hungry.at</td>
									</tr>
									<tr>
										<td class="col1"><input class="content-checkbox" type="checkbox" name="select10"></td>
										<td class="col2">Peter</td>
										<td class="col3">Rohrmoser</td>
										<td class="col4 last-col">peter@hungry.at</td>
									</tr>
								</tbody>
							</table>
						</div>
						<div class="pagination">
							<ul>
								<li class="pagination-active"><a href="#">1</a></li>
								<li><a href="#">2</a></li>
								<li><a href="#">3</a></li>
								<li><a href="#">4</a></li>
								<li><a href="#">5</a></li>
							</ul>
						</div>
					</div><div class="content-col">
						<img src="assets/illustrations/co-workers.svg" alt="Mitarbeiter" class="content-illustration">
					</div>
				</div>
			</div>
		</div>	
	</div>
	
	<footer id="footer">
		<ul>
			<li><a href="#">Datenschutz</a></li>
			<li><a href="#">Impressum</a></li>
			<li><a href="#">Support</a></li>
		</ul>
		<a href="/" class="footer-logo">
			<img src="assets/svg/logo-blue.svg" alt="mindsetters">
		</a>
	</footer>
</div>


<script src="assets/js/plugins.js?<?php echo time(); ?>"></script>
<script src="assets/js/javascript.js?<?php echo time(); ?>"></script>

</body>
</html>
