$('#hamburger').click(function(){ 
  $('body').toggleClass('nav-shown'); 
});

var $carousel = $('.training-carousel').flickity({
  draggable: true,
  cellAlign: 'left',
  prevNextButtons: false,
  contain: true,
});


if ($('.training-carousel').length) {
  $('.subpage').append('<div class="dragcursor"></div>');
  
  gsap.set('.dragcursor', {xPercent: -50, yPercent: -50});
  
  const ball = document.querySelector('.dragcursor');
  const pos = { x: window.innerWidth / 2, y: window.innerHeight / 2 };
  const mouse = { x: pos.x, y: pos.y};
  
  const speed = 0.35;
  var active = false;
  
  const xSet = gsap.quickSetter(ball, "x", "px");
  const ySet = gsap.quickSetter(ball, "y", "px");
  
  window.addEventListener("mousemove", e => {    
    mouse.x = e.x;
    mouse.y = e.y;  
  });
  
  gsap.ticker.add(cursor);
  
  function cursor(){
    if(!active){
      const dt = 1.0 - Math.pow(1.0 - speed, gsap.ticker.deltaRatio()); 
      pos.x += (mouse.x - pos.x) * dt;
      pos.y += (mouse.y - pos.y) * dt;
      xSet(pos.x);
      ySet(pos.y);
    }
  }
  
  $(window).load(function() {
    $('.flickity-viewport').hover(function(){     
      gsap.to(ball, {
        scale: 1,
        duration: 0.125
      });
    },function(){    
      gsap.to(ball, {
        scale: 0,
        duration: 0.125
      });     
    });
  });
  
  $carousel.on( 'dragMove.flickity', function(e, mousemove, pointer, moveVector) {
     
    mouse.x = e.clientX;
    mouse.y = e.clientY;
    
    gsap.to({}, 0.0, {
    onUpdate: function() {
      gsap.set(ball, {
      x: mouse.x,
      y: mouse.y
      })
    }
    })
    
    //active = true;
  });
  
  $carousel.on( 'dragStart.flickity', function() {
    //active = true;
  });
  
  $carousel.on( 'dragEnd.flickity', function() {
    active = false;   
  });
}